/******************************************************************* -*-c++-*-
player.h - class Player header file.

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
******************************************************************************/
#ifndef PLAYER_H
#define PLAYER_H
#include <string>

#include "board.h"
#include "action.h"

/*-------------------------| class Player |-----------------------------------
A base class for different players.  See class ComputerPlayer and
class HumanPlayer for actual players.
*/
class Player {
protected :
    Square::Piece piece;       // Piece (X or O) used by player
    std::string   name;
    bool          interactive;    // => needs human input.
public :
    Player(void) : piece(Square::x), name(""),
        interactive(true) {}
    Player(Square::Piece p, bool i) : piece(p), name(""),
        interactive(i) {}
    virtual ~Player() {}

    virtual void configure(void);

    Square::Piece get_piece(void) const { return piece; }
    const std::string& get_name(void) const { return name; }
    bool is_interactive(void) const { return interactive; }

    virtual PlayerAction* get_move(const Board& board) = 0;

    virtual std::string get_hint(void) const { return "Not available"; }
};

// Do a move
class MoveAction : public PlayerAction {
private :
    Move move;
public :
    MoveAction(const Move& m) : move(m) {}

    virtual bool execute(Board& board, Player& player, Player& opponent);
};

#endif // #ifndef PLAYER_H


