/*****************************************************************************
player.cc - class Player, HumanPlayer, ComputerPlayer source file.

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*****************************************************************************/
#include "player.h"

using namespace std;

void Player::configure(void)
/*****************************************************************************
Read player's name interactively.
*/
{
    cout << "Enter name: " << flush;
    getline(cin, name);
}

bool MoveAction::execute(Board& board, Player& player, Player& opponent)
/******************************************************************************
Carries out the move.
*/
{
    if( !player.is_interactive() ) {
	cout << board.get_move_number() << " " << move << endl;
    }
    board.do_move(player.get_piece(), move);
    return true;
}
