/*****************************************************************************
movetree.h - class MoveTree and related classes header file.

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
******************************************************************************

The MoveTree is utilized by ComputerPlayer to store the tree of moves tried by
the computer.
*/
#include <cstddef>
#include "board.h"

class MoveNode {
protected :
    Move move;
    MoveNode* best_branch;
    MoveNode* current_branch;

    MoveNode(void) : move(), best_branch(NULL), current_branch(NULL) {}
    MoveNode(const Move& m) : move(m), best_branch(NULL), current_branch(NULL)
      {}
    ~MoveNode() { destroy_branches(); }

    void destroy_branches(void);

    friend class MoveTreeIterator;
    friend class MoveTree;
};

class MoveTreeIterator {
protected :
    MoveNode *current;
public :
    MoveTreeIterator(void) : current(NULL) {}
    MoveTreeIterator(const MoveTreeIterator& start) : current(start.current) {}
    MoveTreeIterator(MoveNode *start) : current(start) {}
    ~MoveTreeIterator() {}

    void move_up_best_branch(void) {
        if( current!=NULL ) {
            current=current->best_branch;
        }
    }

    const Move& operator* (void) const { return current->move; }
    operator bool () const { return current!=NULL; }

    friend class MoveTree;
};


class MoveTree {
protected :
    MoveNode* root;
public :
    typedef MoveTreeIterator Iterator;

    MoveTree(void) { root=new MoveNode(Move(-1,-1)); }
    ~MoveTree() { destroy(); delete root; }

    Iterator get_root(void) const { return Iterator(root); }

    Iterator add_branch(const Move& move, Iterator& i);
    void reset_best_branch(Iterator& i);
    
    void destroy(void);
};
