/*****************************************************************************
movetree.cc - class MoveTree and related classes source code.

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*****************************************************************************/
#include "movetree.h"

void MoveNode::destroy_branches(void)
/*****************************************************************************
Destroys all branches leading from the node.
*/
{
    if( best_branch!=NULL ) {
        best_branch->destroy_branches();
        delete best_branch;
        best_branch=NULL;
    }
    if( current_branch!=NULL ) {
        current_branch->destroy_branches();
        delete current_branch;
        current_branch=NULL;
    }
}


void MoveTree::reset_best_branch(Iterator& node)
/*****************************************************************************
Sets the best branch to the current branch.
*/
{
    MoveNode* temp=node.current->current_branch;
    node.current->current_branch=node.current->best_branch;
    node.current->best_branch=temp;
}

MoveTree::Iterator MoveTree::add_branch(const Move& move, Iterator& node)
/*****************************************************************************
Deletes the old branch and creates a new one.
*/
{
    if( node.current->current_branch ) {
        node.current->current_branch->destroy_branches();
        delete node.current->current_branch;
    }
    node.current->current_branch=new MoveNode(move);

    return Iterator(node.current->current_branch);
}


void MoveTree::destroy(void)
/*****************************************************************************
Destroy the tree
*/
{
    root->destroy_branches();
}
