/*****************************************************************************
main.cc - Main source file.

Copyright 2002 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*****************************************************************************/
#include <cctype>
#include <iostream>

#include "game.h"
#include "humanplayer.h"
#include "computerplayer.h"
#include "computer2.h"

using namespace std;

int main(void)
{
    cout << "Reversi " VERSION "\nCopyright 2002 David Vrabel.\n"
        "This is free software distributed under the terms of the GNU GPL.\n\n";
  
    Board   board;
    Player* players[2]={0,0};

    for( int i=0; i<2; i++ ) {
        do {
            cout << "Select player " << i+1 
                 << " ([H]uman or [C]omputer): " << flush;
            string temp;
            getline(cin, temp);
            switch( tolower(temp[0]) ) {
            case 'h' :
                players[i]=new HumanPlayer(static_cast<Square::Piece>(i+1));
                break;
            case 'c' :
                players[i]=new ComputerPlayer2(static_cast<Square::Piece>(i+1));
                break;
            default :
                cout << "Invalid entry." << endl;
                break;
            }
        } while( !players[i] );
        players[i]->configure();
    }
    
    Game game(board, *players[0], *players[1]);
    game.start();

    cout << endl << board << endl;
    Square::Piece winner=board.get_winner();
    if( winner==Square::blank ) {
        cout << "A draw." << endl;
    } else {
        cout << players[winner-1]->get_name() << " won!" << endl;
    }
    return 0;
}
