/* humanplayer.h - class HumanPlayer header file.                    -*-c++-*-

Copyright (C) 2001 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef HUMANPLAYER_H
#define HUMANPLAYER_H

#include "board.h"
#include "player.h"

/*---------------------------| class HumanPlayer |---------------------------- 
A player accepting input interactively.
*/
class HumanPlayer : public Player {
private :
    enum CommandType {
        ERROR, MOVE, EXIT, HINT, REDRAW, HELP
    };

    CommandType get_command( Move& move );
    void display_help(void) const;
public :
    HumanPlayer(void) : Player() {}
    HumanPlayer(Square::Piece p) : Player(p,true) {}
    virtual ~HumanPlayer() {}

    virtual PlayerAction* get_move(const Board& board);
};

// Exit game
class ExitAction : public PlayerAction {
public :
    virtual bool execute(Board& board, Player& player, Player& opponent);
};

// Display hint
class HintAction : public PlayerAction {
public :
    virtual bool execute(Board& board, Player& player, Player& opponent);
};  

#endif // #ifndef HUMANPLAYER_H
