/*****************************************************************************
game.cc - class Game source file.

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*****************************************************************************/
#include "game.h"

using namespace std;

Game::Game(Board& b, Player& p1, Player& p2) : board(b)
/*****************************************************************************
Sets up a game with a board and two players
*/
{
    players[0]=&p1;
    players[1]=&p2;
}

void Game::start(void)
/*****************************************************************************
Carries out the main game loop.
*/
{
    for(;;) {
        for( int p=0,o=1; p<2; p++, o-- ) {
            if( players[p]->is_interactive() ) {
                cout << endl << board << endl;
            }
            bool moved;
            do {
                PlayerAction* action=players[p]->get_move(board);
                moved=action->execute(board, *players[p], *players[o]);
                delete action;
            } while( !moved );
            if( board.is_game_over() ) {
                return;
            }
        }
    }
}
