/* computerplayer.h - class ComputerPlayer header file. -*-c++-*-

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef COMPUTER2_H
#define COMPUTER2_H

#include <ctime>
#include <string>

#include "player.h"
#include "computerplayer.h"

/*
------------------------| class ComputerPlayer2 |------------------------------
Computer player similar to ComputerPlayer except that the search time is
limited.

The algorithm used is depth first iterative deepening.
  set search_depth to 1
  repeat  
    Find best move using depth first search to maximum depth search_depth
    increment search_depth
  until out of time
*/

class ComputerPlayer2 : public ComputerPlayer {
protected :
    double search_time;

    virtual bool deep_enough( int depth ) const;
public :
    ComputerPlayer2(Square::Piece p) : ComputerPlayer(p),
        search_time(1) {}
    virtual ~ComputerPlayer2() {}

    virtual void          configure(void);
    virtual PlayerAction* get_move(const Board& board);
    virtual std::string   get_hint() const;
private :
    double start_time; /* s */
    std::string hint;

    class OutOfTime {};
};

#endif // #ifndef COMPUTER2_H

