/******************************************************************************
action.h - class PlayerAction header file.

Copyright (C) 1999 David Vrabel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
******************************************************************************/
#ifndef ACTION_H
#define ACTION_H

class Board;
class Player;

/******************************| class PlayerAction |*************************
PlayerAction is used to return a move made by a player.  Inherit from this to
implement a particular action.
*/
class PlayerAction {
public :
    virtual bool execute(Board& board, Player& player, Player& opponent)=0;
};

#endif // #ifndef ACTION_H
    
