# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: background.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: background.py,v 1.29 2007/03/09 14:11:55 digitalxero Exp $
#
# Description: This file contains some of the basic definitions for the chat
# utilities in the orpg project.
#
__version__ = "$Id: background.py,v 1.29 2007/03/09 14:11:55 digitalxero Exp $"

from base import *
import thread
import urllib
import os.path
import time
import orpg.orpg_xml as orpg_xml

##-----------------------------
## background layer
##-----------------------------

BG_NONE = 0
BG_TEXTURE = 1
BG_IMAGE = 2
BG_COLOR = 3

class layer_back_ground(layer_base):
    def __init__(self, canvas):
        self.canvas = canvas
        self.log = self.canvas.log
        self.log.log("Enter layer_back_ground", ORPG_DEBUG)
        self.settings = self.canvas.settings
        layer_base.__init__(self)
        self.canvas = canvas
        self.r_h = RGBHex()
        self.clear()
        self.log.log("Exit layer_back_ground", ORPG_DEBUG)

    def error_loading_image(self, image):
        self.log.log("Enter layer_back_ground->error_loading_image(self, image)", ORPG_DEBUG)
        msg = "Unable to load image:" + `image`
        dlg = wx.MessageDialog(self.canvas,msg,'File not Found',wx.ICON_EXCLAMATION)
        dlg.ShowModal()
        dlg.Destroy()
        self.log.log("Exit layer_back_ground->error_loading_image(self, image)", ORPG_DEBUG)

    def clear(self):
        self.log.log("Enter layer_back_ground->clear(self)", ORPG_DEBUG)
        self.type = BG_NONE
        self.bg_bmp = None
        self.bg_color = None
        self.img_path = None
        self.local = False
        self.localPath = ''
        self.localTime = -1
        self.isUpdated = True
        self.log.log("Exit layer_back_ground->clear(self)", ORPG_DEBUG)

    def get_type(self):
        self.log.log("Enter layer_back_ground->get_type(self)", ORPG_DEBUG)
        self.log.log("Exit layer_back_ground->get_type(self)", ORPG_DEBUG)
        return self.type

    def get_img_path(self):
        self.log.log("Enter layer_back_ground->get_type(self)", ORPG_DEBUG)
        if self.img_path:
            self.log.log("Exit layer_back_ground->get_type(self) return " + self.img_path, ORPG_DEBUG)
            return self.img_path
        else:
            self.log.log("Exit layer_back_ground->get_type(self) return None", ORPG_DEBUG)
            return ""

    def get_color(self):
        self.log.log("Enter layer_back_ground->get_color(self)", ORPG_DEBUG)
        hexcolor = "#FFFFFF"
        if self.bg_color:
            (red,green,blue) = self.bg_color.Get()
            hexcolor = self.r_h.hexstring(red, green, blue)
        self.log.log("Exit layer_back_ground->get_color(self)", ORPG_DEBUG)
        return hexcolor

    def set_texture(self, path):
        self.log.log("Enter layer_back_ground->set_texture(self, path)", ORPG_DEBUG)
        self.isUpdated = True

	#Here! TaS
        self.type = BG_TEXTURE
        if self.img_path != path:
            try:
                self.bg_bmp = ImageHandler.load(path, 'texture', self.bg_bmp).ConvertToBitmap()
                if self.bg_bmp == None:
                    self.log.log("Invalid image type!", ORPG_GENERAL)
                    raise Exception, "Invalid image type!"
            except:
                self.error_loading_image(path)
        self.img_path = path
        self.log.log("Enter layer_back_ground->set_texture(self, path)", ORPG_DEBUG)

    def set_image(self, path, object_type, image_object):
        self.isUpdated = True

	#Here! TaS
        self.type = BG_IMAGE
        if self.img_path != path:
            self.bg_bmp = ImageHandler.load(path, object_type, image_object).ConvertToBitmap()
            try:
                if self.bg_bmp == None:
                    self.log.log("Invalid image type!", ORPG_GENERAL)
                    raise Exception, "Invalid image type!"
            except:
                self.error_loading_image(path)
        self.img_path = path
        return (self.bg_bmp.GetWidth(),self.bg_bmp.GetHeight())

    def set_color(self, color):
        self.log.log("Enter layer_back_ground->set_color(self, color)", ORPG_DEBUG)
        self.isUpdated = True
        self.type = BG_COLOR
        self.bg_color = color
        self.canvas.SetBackgroundColour(self.bg_color)
        self.log.log("Exit layer_back_ground->set_color(self, color)", ORPG_DEBUG)

    def layerDraw(self, dc, topleft, size):
        if self.bg_bmp == None or not self.bg_bmp.Ok() or ((self.type != BG_TEXTURE) and (self.type != BG_IMAGE)):
            return
        bmpW = self.bg_bmp.GetWidth()
        bmpH = self.bg_bmp.GetHeight()
        if self.type == BG_TEXTURE:
            x = int(topleft[0]/bmpW)*bmpW
            while x < topleft.x + size.width:
                y = int(topleft.y/bmpH)*bmpH
                while y < topleft.y + size.height:
                    dc.DrawBitmap(self.bg_bmp, x, y)
                    y += bmpH
                x += bmpW
        elif self.type == BG_IMAGE:
            dc.DrawBitmap(self.bg_bmp, 0, 0)

    def layerToXML(self, action="update"):
        self.log.log("Enter layer_back_ground->layerToXML(self, " + action + ")", ORPG_DEBUG)
        xml_str = "<bg"
        if self.bg_color != None:
            xml_str += ' color="' + self.bg_color.GetAsString(wx.C2S_HTML_SYNTAX) + '"'
        if self.img_path != None:
            xml_str += ' path="' + urllib.quote(self.img_path).replace('%3A', ':') + '"'
        if self.type != None:
            xml_str += ' type="' + str(self.type) + '"'
        if self.local and self.img_path != None:
            xml_str += ' local="True"'
            xml_str += ' localPath="' + urllib.quote(self.localPath).replace('%3A', ':') + '"'
            xml_str += ' localTime="' + str(self.localTime) + '"'
        xml_str += "/>"
        self.log.log(xml_str, ORPG_DEBUG)
        self.log.log("Exit layer_back_ground->layerToXML(self, " + action + ")", ORPG_DEBUG)
        if (action == "update" and self.isUpdated) or action == "new":
            self.isUpdated = False
            return xml_str
        else:
            return ''

    def layerTakeDOM(self, xml_dom):
        path = urllib.unquote(xml_dom.getAttribute("path"))

        if xml_dom.hasAttribute("color"):
            color = wx.NamedColor(xml_dom.getAttribute("color"))
            self.set_color(color)
        if xml_dom.hasAttribute("type"):
            type = int(xml_dom.getAttribute("type"))

        if type == BG_TEXTURE:
            if path != "":
                self.set_texture(path, "texture", 1)
        elif type == BG_IMAGE:
            if path != "":
                self.set_image(path, "background", 1)
        elif type == BG_NONE:
            self.clear()
