# Base class for game tree nodes.
#
# Copyright (C) 2011 David Vrabel
# Copyright (C) 2000-2001 The OpenRPG Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

from orpg.orpg_windows import *
import orpg.dirpath
from orpg.orpg_xml import *
from orpg.orpgCore import open_rpg

class node_handler(object):
    """ Base nodehandler with virtual functions and standard implmentations """
    def __init__(self,xml_dom,tree_node):
        self.master_dom = xml_dom
        self.mytree_node = tree_node
        self.tree = open_rpg.get_component('tree')
        self.myeditor = None # designing
        self.tree.SetPyData(tree_node, self)

    def on_drop(self, dropped, where):
        """Move a dropped tree item.

        Where the dropped item is moved to depends on where it was
        dropped on the target item: before (upper half), after (lower
        half), or as a child (to the right).
        """
        if dropped == self or self.tree.is_parent_node(self.mytree_node, dropped.mytree_node):
            return
        xml_dom = dropped.delete()
        parent = self.master_dom.parentNode
        if where & wx.TREE_HITTEST_ONITEMRIGHT:
            xml_dom = self.master_dom.appendChild(xml_dom)
            parent_node = self.mytree_node
            prev_sib = None
        elif where & wx.TREE_HITTEST_ONITEMUPPERPART:
            xml_dom = parent.insertBefore(xml_dom,self.master_dom)
            parent_node = self.tree.GetItemParent(self.mytree_node)
            prev_sib = self.tree.GetPrevSibling(self.mytree_node)
            if not prev_sib.IsOk():
                prev_sib = parent_node
        else:
            next_sib = self.tree.GetNextSibling(self.mytree_node)
            if next_sib:
                node = self.tree.GetPyData(next_sib)
                xml_dom = parent.insertBefore(xml_dom, node.master_dom)
            else:
                xml_dom = parent.appendChild(xml_dom)
            parent_node = self.tree.GetItemParent(self.mytree_node)
            prev_sib = self.mytree_node
        self.tree.load_xml(xml_dom, parent_node, prev_sib)

    def toxml(self, pretty = False):
        return toxml(self.master_dom, pretty)

    def delete(self):
        """ removes the tree_node and xml_node, and returns the removed xml_node """
        self.tree.Delete(self.mytree_node)
        parent = self.master_dom.parentNode
        return parent.removeChild(self.master_dom)

    def __get_name(self):
        return self.master_dom.getAttribute("name")

    def __set_name(self, name):
        self.master_dom.setAttribute("name", name)
        if self.tree.GetItemText(self.mytree_node) != name:
            self.tree.SetItemText(self.mytree_node, name)

    name = property(__get_name, __set_name)

    def __get_icon(self):
        name = self.master_dom.getAttribute("icon")
        return self.tree.icons[name]

    def __set_icon(self, icon):
        name = self.tree.icons.name(icon)
        self.master_dom.setAttribute("icon", name)
        self.tree.SetItemImage(self.mytree_node, icon)
        self.tree.SetItemImage(self.mytree_node, icon, wx.TreeItemIcon_Selected)
        self.tree.Refresh()

    icon = property(__get_icon, __set_icon)
