# Freehand line tool
#
# Copyright (C) 2009 David Vrabel

from orpg.whiteboard. import WhiteboardLine

class FreehandTool(WhiteboardTool):
    def __init__ (self, whiteboard, ui):
        self.whiteboard = whiteboard
        self.ui = ui
        self.working_line = None

    def on_left_down(self, pos):
        self.working_line = Line(map_ui.line_width, map_ui.color)
        self.whiteboard.add(self.working_line)
        self.working_line.add_point(pos.x, pos.y)

    def on_left_up(self, pos):
        if self.working_line:
            self.map.complete(self.working_line)
            self.working_line = None

    def on_motion(self, pos):
        if not self.working_line:
            return
        self.working_line.add_point(pos.x, pos.y)
        self.map_ui.refresh_canvas()
