import sys
import time
import platform
import wx
import orpg.orpg_version

class system_check:

    def start(self,log_file='flexirpg_sysinfo.txt'):
        self.log_file = open(log_file,'w')
        self.log_file.write("FlexiRPG System Info " + time.strftime( '%Y-%m-%d', time.localtime( time.time() ) ))
        self.check_openrpg()
        self.check_py()
        self.check_wxpython()
        self.check_platform()
        self.log_file.close()

    def check_wxpython(self):
        self.log_file.write("\nwxPython Version: " + wx.__version__)

    def check_py(self):
        self.log_file.write("\nPython: " + sys.version)

    def check_platform(self):
        self.log_file.write("\nPlatform: " + platform.platform())

    def check_openrpg(self):
        self.log_file.write("\nFlexiRPG Version: " + orpg.orpg_version.VERSION + orpg.orpg_version.VERSION_EXTRA)

if __name__ == "__main__":
    syscheck = system_check()
    syscheck.start()
